// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderDocumentMailer.view.list.Document', {

    override: 'Shopware.apps.Order.view.list.Document',

    /**
     * @Override
     */
    getColumns: function () {
        var columns = this.callParent();

        // With the release of SW 5.3 Shopware introduced its own send mail button for documents. Since the new
        // Shopware functionality lacks some features of our implementation (document type specific templates) while
        // at the same time adds some new features (multiple documents as attachement) we decided to keep both buttons
        // until Shopware has integrated missing features into their own implementation (PR is pending).
        // In SW < 5.3 our button must still be available as usual while in SW >= 5.3 the icon of our button will be
        // changed to make it distinguishable from Shopware's own button and a tooltip will be added to the Shopware
        // button to inform the user about the differing functionalities.
        // If this flag is true our button will be adapted as described for SW >= 5.3 version, otherwise the (old)
        // SW < 5.3 version of our button is rendered.
        var useAlternativeMailButton = ViisonCommonApp.getConfig('useAlternativeMailButton', 'ViisonPickwareERPOrderDocumentMailer');

        // Try to find an action column
        var actionColumn = null;
        Ext.each(columns, function (column) {
            if (column.xtype === 'actioncolumn') {
                actionColumn = column;
                actionColumn.width += 30;

                return false;
            }

            return undefined;
        });
        if (!actionColumn) {
            // Action column does not exist yet, hence create one
            actionColumn = {
                xtype: 'actioncolumn',
                width: 30,
                items: [],
            };
            columns.push(actionColumn);
        }

        if (useAlternativeMailButton) {
            // Inform user about the different purposes of the send mail buttons by
            // adding an appropriate tooltip to Shopware's send document button
            actionColumn.items.forEach(function (item) {
                if (item.iconCls === 'sprite-mail-send') {
                    item.tooltip = ViisonCommonApp.getSnippet(
                        'column/action/shopware_buttons/send/tooltip',
                        'backend/viison_pickware_erp_order_document_mailer/main'
                    );
                }
            });
        }

        // Add a 'send' action
        actionColumn.items.push({
            iconCls: useAlternativeMailButton ? 'marketing--newsletters' : 'sprite-mail-send',
            tooltip: ViisonCommonApp.getSnippet(
                'column/action/send/tooltip',
                'backend/viison_pickware_erp_order_document_mailer/main'
            ),
            scope: this,
            getClass: function (html, metadata, record) {
                if (!this.fireEvent('ViisonPickwareERP.showDocumentMailButton', record)) {
                    return 'x-hidden';
                }

                return undefined;
            },
            handler: function (grid, rowIndex) {
                this.fireEvent('sendDocument', this, grid.getStore().getAt(rowIndex));
            },
        });

        return columns;
    },

});
