// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderEventBus.store.Order', {
    override: 'Shopware.apps.Order.store.Batch',

    /**
     * @override
     */
    constructor: function () {
        this.callParent(arguments);

        // Fire an event on the custom event bus to allow other applications to modify the store before it is synced
        this.on('beforesync', function () {
            ViisonPickwareERPOrderEventBus.fireEvent('collectBatchStoreParams', this);
        }, this);
    },
});
