// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderListReturnShipmentStatus.view.list.Filter', {

    override: 'Shopware.apps.Order.view.list.Filter',

    /**
     * Adds a new filter option for filtering orders based on their return status.
     *
     * @return Ext.form.Panel
     */
    createFilterForm: function () {
        var form = this.callParent(arguments);

        // Find the position of the default status filter field
        var orderStatusFieldIndex = -1;
        form.items.each(function (field, index) {
            if (field.name === 'orders.status') {
                orderStatusFieldIndex = index;

                return false;
            }

            return true;
        });

        // Create and add a return status selection combo box for filtering
        var statusComboBox = Ext.create('Shopware.apps.ViisonCommonComboBox.view.ComboBox', {
            name: 'attribute.pickwareReturnShipmentStatusId',
            fieldLabel: ViisonCommonApp.getSnippet('filter/field/viison_pickware_erp_return_status_id/label', 'backend/viison_pickware_erp_order_list_return_shipment_status/main'),
            store: Ext.create('Shopware.apps.ViisonPickwareERPReturnShipment.store.ReturnShipmentStatus'),
            displayField: 'displayName',
            allowBlank: true,
            emptyText: ViisonCommonApp.getSnippet('filter/field/viison_pickware_erp_return_status_id/empty_text', 'backend/viison_pickware_erp_order_list_return_shipment_status/main'),
        });
        form.insert((orderStatusFieldIndex + 1), statusComboBox);

        // Manually trigger an update, because the store contains static data
        statusComboBox.updateSelectedValue(statusComboBox.store);

        return form;
    },

});
