// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderListReturnShipmentStatus.view.list.List', {

    override: 'Shopware.apps.Order.view.list.List',

    /**
     * Adds a new column for the return status attribute of an order.
     *
     * @return {Ext.grid.column.Column[]}
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Find the position of the default order status column
        var orderStatusColumnIndex = -1;
        Ext.each(columns, function (column, index) {
            if (column.dataIndex === 'status') {
                orderStatusColumnIndex = index;

                return false;
            }

            return true;
        });

        // Insert the return status column
        columns.splice((orderStatusColumnIndex + 1), 0, {
            dataIndex: 'pickwareReturnShipmentStatusId',
            header: ViisonCommonApp.getSnippet('column/pickware_return_shipment_status_id/header', 'backend/viison_pickware_erp_order_list_return_shipment_status/main'),
            sortable: true,
            width: 100,
            renderer: function (value) {
                if (value === null) {
                    return ViisonCommonApp.getSnippet(
                        'column/pickware_return_shipment_status_id/default_value',
                        'backend/viison_pickware_erp_order_list_return_shipment_status/main'
                    );
                }

                return ViisonPickwareERPReturnShipmentReturnShipmentStatus.localizedDisplayName(value);
            },
        });

        return columns;
    },

});
