// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

ViisonCommonApp.registerExtraModelFields(
    'Shopware.apps.Order.model.Position',
    [
        { name: 'shipped', type: 'int' },
        { name: 'pickwareCanceledQuantity', type: 'int', defaultValue: 0 },
        { name: 'pickwareReturnedQuantity', type: 'int', defaultValue: 0 },
        { name: 'pickwareCanceledReturnedQuantity', type: 'int', defaultValue: 0 },
        {
            name: 'viisonCanceledTotal',
            type: 'float',
            convert: function (value, record) {
                if (!Ext.isNumeric(record.get('price'))) {
                    return record.get('price');
                }

                return record.get('price') * record.get('pickwareCanceledQuantity');
            },
        },
        { name: 'pickwareIsStockManaged', type: 'boolean', defaultValue: false },
    ]
);
