// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderOverwriteProtection.controller.List', {

    override: 'Shopware.apps.Order.controller.List',

    /**
     * @inheritDoc
     */
    onSaveOrder: function (editor, event, orderStore) {
        var orderRecord = orderStore.getAt(event.rowIdx);
        if (orderRecord == null) {
            return;
        }

        // Add a listener to the orderStore. The listener updates the "pickwareLastChanged" timestamp in the current
        // order detail window after the order has been saved. The "pickwareLastChanged" timestamp is used for optimistic
        // locking.
        orderStore.addListener('write', function (store, operation) {
            if (!operation.success) {
                return;
            }

            var updatedOrder = Ext.JSON.decode(operation.response.responseText).data;
            if (updatedOrder.id !== orderRecord.get('id')) {
                return;
            }

            orderRecord.set('pickwareLastChanged', updatedOrder.pickwareLastChanged);
        }, this, {
            single: true,
        });

        this.callParent(arguments);
    },

    /**
     * @inheritDoc
     */
    onDeletePosition: function (position, store) {
        var order = this.subApplication.getStore('Order').getById(position.get('orderId'));

        position.viisonParamsForSaveRequest = {
            // Use ISO format to also commit the time zone and avoid problem because of mismatching timezones of client
            // and server.
            pickwareLastChanged: order.get('pickwareLastChanged').toISOString(),
        };

        store.addListener('write', function (_, operation) {
            if (!operation.success) {
                return;
            }

            var updatedOrder = Ext.JSON.decode(operation.response.responseText).data;
            if (updatedOrder.id !== position.get('orderId')) {
                return;
            }

            order.set('pickwareLastChanged', updatedOrder.pickwareLastChanged);
        }, this, {
            single: true,
        });

        this.callParent(arguments);
    },
});
