// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderOverwriteProtection.model.Position', {
    override: 'Shopware.apps.Order.model.Position',

    viisonParamsForSaveRequest: {},

    /**
     * @override
     */
    save: function (config) {
        // Add the 'pickwareLastChanged' date to the request parameters
        // The property 'viisonParamsForSaveRequest' has been injected into the model by the onSavePosition override in
        // Shopware.apps.ViisonPickwareERPOrderOverwriteProtection.controller.Detail
        config = config || {};
        config.params = config.params || {};
        Ext.apply(config.params, this.viisonParamsForSaveRequest);

        this.callParent(arguments);
    },

    /**
     * @override
     */
    destroy: function (config) {
        // The property 'viisonParamsForSaveRequest' has been injected into the model by the onDeleteMultiplePositions
        // override in Shopware.apps.ViisonPickwareERPOrderOverwriteProtection.controller.Detail
        // Add the 'pickwareLastChanged' date to the request parameters
        config = config || {};
        config.params = config.params || {};
        Ext.apply(config.params, this.viisonParamsForSaveRequest);

        this.callParent(arguments);
    },
});
