// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderReturnShipment.model.ReturnShipment', {

    extend: 'Ext.data.Model',

    fields: [
        { name: 'id', type: 'int' },
        { name: 'number', type: 'string' },
        { name: 'orderId', type: 'int' },
        { name: 'created', type: 'date' },
        { name: 'userId', type: 'int' },
        { name: 'userName', type: 'string' },
        { name: 'statusId', type: 'int' },
        { name: 'documentId', type: 'int', useNull: true },
        {
            name: 'numberOfReturnedItems',
            type: 'int',
            convert: function (val, record) {
                var itemsCount = 0;
                Ext.each(record.raw.items, function (returnShipmentItem) {
                    itemsCount += returnShipmentItem.returnedQuantity;
                });

                return itemsCount;
            },
        },
    ],

    associations: [
        {
            type: 'hasMany',
            model: 'Shopware.apps.ViisonPickwareERPOrderReturnShipment.model.ReturnShipmentItem',
            name: 'getItems',
            associationKey: 'items',
        },
    ],

    /**
     * @returns {boolean}
     */
    isFinalizable: function () {
        return ViisonPickwareERPReturnShipmentReturnShipmentStatus.returnShipmentCanBeFinalized(this.get('statusId'));
    },

    /**
     * @returns {boolean}
     */
    isTypeCancelled: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_CANCELLED_ID;
    },

    /**
     * @returns {boolean}
     */
    isTypeFinalized: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_COMPLETED_ID;
    },

});
