// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderReturnShipment.store.ReturnShipment', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPOrderReturnShipment.model.ReturnShipment',

    remoteFilter: true,
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPOrderReturnShipment/getReturnShipments'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

    /**
     * Scopes the store to the given order by setting the order id as filter.
     *
     * @param {number} orderId
     */
    setOrderId: function (orderId) {
        this.filters.add('order', Ext.create('Ext.util.Filter', {
            property: 'returnShipment.orderId',
            value: orderId,
        }));
    },

    /**
     * @returns {boolean}
     */
    containsAtLeastOneCancellableReturnShipment: function () {
        var containsCancellableReturnShipments = false;
        this.each(function (returnShipment) {
            if (ViisonPickwareERPReturnShipmentReturnShipmentStatus.returnShipmentCanBeCancelled(returnShipment.get('statusId'))) {
                containsCancellableReturnShipments = true;
            }
        });

        return containsCancellableReturnShipments;
    },

    /**
     * @returns {boolean}
     */
    containsAtLeastOneFinalizableReturnShipment: function () {
        return this.getFinalizableReturnShipments().length > 0;
    },

    /**
     * @returns {Shopware.apps.ViisonPickwareERPOrderReturnShipment.model.ReturnShipment[]}
     */
    getFinalizableReturnShipments: function () {
        var finalizableReturnShipments = [];

        this.each(function (returnShipment) {
            if (returnShipment.isFinalizable()) {
                finalizableReturnShipments.push(returnShipment);
            }
        });

        return finalizableReturnShipments;
    },

});
