// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderReturnShipment.view.detail.ReturnShipmentItemList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_order_return_shipment-return_shipment_item_list',
    cls: 'viison_pickware_erp_order_return_shipment-return_shipment_item_list viison-common--grid has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_order_return_shipment/main',

    autoScroll: true,
    viewConfig: {
        loadMask: false,
        enableTextSelection: true,
    },
    border: false,
    style: {
        border: 'none !important',
    },
    bodyStyle: {
        border: 'none !important',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.columns = this.getColumns();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    getColumns: function () {
        return [
            {
                dataIndex: 'articleNumber',
                header: this.getViisonSnippet('return_shipment_item_list/column/article_number'),
                sortable: true,
                width: 120,
            }, {
                dataIndex: 'articleName',
                header: this.getViisonSnippet('return_shipment_item_list/column/article_name'),
                sortable: true,
                flex: 1,
            }, {
                dataIndex: 'returnedQuantity',
                header: this.getViisonSnippet('return_shipment_item_list/column/returned_qunatity'),
                sortable: true,
                align: 'right',
                width: 100,
            }, {
                dataIndex: 'writtenOffQuantity',
                header: this.getViisonSnippet('return_shipment_item_list/column/written_off_qunatity'),
                sortable: true,
                align: 'right',
                width: 100,
            }, {
                xtype: 'actioncolumn',
                width: 35,
                align: 'center',
                items: [
                    {
                        iconCls: 'sprite-inbox',
                        tooltip: this.getViisonSnippet('return_shipment_item_list/button/open_article/tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex) {
                            this.fireEvent('openArticle', grid.getStore().getAt(rowIndex));
                        },
                    },
                ],
            },
        ];
    },

});
