// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderReturnShipment.view.detail.ReturnShipmentList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_order_return_shipment-return_shipment_list',
    cls: 'viison-common--grid has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_order_return_shipment/main',

    autoScroll: true,
    viewConfig: {
        loadMask: false,
        enableTextSelection: true,
    },
    border: false,
    style: {
        border: 'none !important',
    },
    bodyStyle: {
        border: 'none !important',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.emptyText = this.getViisonSnippet('return_shipment_list/empty_text');
        this.columns = this.getColumns();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    getColumns: function () {
        return [
            {
                xtype: 'datecolumn',
                header: this.getViisonSnippet('return_shipment_list/column/created'),
                dataIndex: 'created',
                sortable: true,
                width: 120,
                format: 'd.m.Y H:i',
            }, {
                header: this.getViisonSnippet('return_shipment_list/column/number'),
                dataIndex: 'number',
                sortable: true,
                width: 140,
            }, {
                header: this.getViisonSnippet('return_shipment_list/column/status_name'),
                dataIndex: 'statusId',
                sortable: true,
                width: 120,
                renderer: function (value) {
                    return ViisonPickwareERPReturnShipmentReturnShipmentStatus.localizedDisplayName(value);
                },
            }, {
                header: this.getViisonSnippet('return_shipment_list/column/user_name'),
                dataIndex: 'userName',
                sortable: true,
                flex: 1,
            }, {
                header: this.getViisonSnippet('return_shipment_list/column/number_of_returned_items'),
                dataIndex: 'numberOfReturnedItems',
                sortable: true,
                width: 180,
                align: 'right',
            }, {
                xtype: 'actioncolumn',
                width: 80,
                align: 'center',
                items: [
                    {
                        iconCls: 'sprite-document-pdf-text',
                        handler: function (grid, rowIndex) {
                            var record = grid.getStore().getAt(rowIndex);

                            if (record.get('documentId')) {
                                this.fireEvent('openDocument', record);
                            }
                        }.bind(this),
                        getClass: function (html, metadata, record) {
                            if (!record.get('documentId')) {
                                this.items[0].tooltip = ViisonCommonApp.getSnippet(
                                    'return_shipment_list/button/open_document/tooltip/disabled',
                                    'backend/viison_pickware_erp_order_return_shipment/main'
                                );

                                return 'is--disabled';
                            }

                            this.items[0].tooltip = ViisonCommonApp.getSnippet(
                                'return_shipment_list/button/open_document/tooltip/enabled',
                                'backend/viison_pickware_erp_order_return_shipment/main'
                            );

                            return '';
                        },
                    },
                    {
                        iconCls: 'sprite-minus-circle',
                        tooltip: this.getViisonSnippet('return_shipment_list/button/delete_return_shipment/tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex) {
                            this.fireEvent('deleteReturnShipment', grid.getStore().getAt(rowIndex));
                        },
                    }, {
                        iconCls: 'sprite-pencil',
                        tooltip: this.getViisonSnippet('return_shipment_list/button/edit_return_shipment/tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex) {
                            this.fireEvent('editReturnShipment', grid.getStore().getAt(rowIndex));
                        },
                    },
                ],
            },
        ];
    },

});
