// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderReturnShipment.view.detail.Tab', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_order_return_shipment-tab',
    cls: 'viison_pickware_erp_order_return_shipment-tab',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_order_return_shipment/main',

    border: false,
    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('tab/title');
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'viison_pickware_erp_order_return_shipment-return_shipment_list',
                flex: 1,
                store: this.returnShipmentsStore,
            },
            {
                xtype: 'panel',
                itemId: 'returnShipmentItemsContainer',
                hidden: true,
                cls: 'is--return-shipment-items-container',
                title: this.getViisonSnippet('return_shipment_item_list/title'),
                border: false,
                layout: 'fit',
                flex: 2,
                items: [
                    {
                        xtype: 'viison_pickware_erp_order_return_shipment-return_shipment_item_list',
                        itemId: 'returnShipmentItemList',
                        hidden: true,
                    },
                    {
                        xtype: 'container',
                        cls: 'is--return-shipment-items-info',
                        itemId: 'returnShipmentItemsInfo',
                        html: new Ext.XTemplate('<strong>{headline}</strong>{bodyText}').apply({
                            headline: this.getViisonSnippet('return_shipment_item_list/info/headline'),
                            bodyText: this.getViisonSnippet('return_shipment_item_list/info/body_text'),
                        }),
                    },
                ],
            },
        ];
    },

    /**
     * @returns {Ext.toolbar.Toolbar[]}
     */
    createDockedItems: function () {
        return Ext.create('Ext.toolbar.Toolbar', {
            dock: 'top',
            ui: 'shopware-ui',
            cls: 'is--viison-common--toolbar',
            items: [
                {
                    xtype: 'button',
                    itemId: 'addReturnShipmentButton',
                    text: this.getViisonSnippet('toolbar/button/add_return_shipment'),
                    iconCls: 'icon-add',
                    margin: '0 5 0 0',
                    scope: this,
                    handler: function () {
                        this.fireEvent('addReturnShipment');
                    },
                }, {
                    xtype: 'button',
                    itemId: 'cancelReturnShipmentsButton',
                    text: this.getViisonSnippet('toolbar/button/cancel_return_shipments'),
                    iconCls: 'sprite-blue-document--minus',
                    scope: this,
                    disabled: true,
                    handler: function () {
                        this.fireEvent('cancelReturnShipments');
                    },
                }, {
                    xtype: 'button',
                    itemId: 'finalizeReturnShipmentsButton',
                    text: this.getViisonSnippet('toolbar/button/finalize_return_shipments'),
                    iconCls: 'icon-finalize-return-shipments',
                    scope: this,
                    disabled: true,
                    handler: function () {
                        this.fireEvent('finalizeReturnShipments');
                    },
                }, '->', {
                    xtype: 'button',
                    tooltip: this.getViisonSnippet('toolbar/button/reload_return_shipments/tooltip'),
                    iconCls: 'icon-reload',
                    scope: this,
                    handler: function () {
                        this.fireEvent('reloadReturnShipments');
                    },
                },
            ],
        });
    },

    /**
     * @param {string} message
     */
    showLoadMask: function (message) {
        this.loadMask = this.loadMask || new Ext.LoadMask(this);

        this.loadMask.msg = message || this.getViisonSnippet('loading_mask/text');
        this.loadMask.show();
    },

    hideLoadMask: function () {
        this.loadMask.hide();
    },

    showReturnShipmentItemsContainer: function () {
        this.down('#returnShipmentItemsContainer').setVisible(true);
    },

    hideReturnShipmentItemsContainer: function () {
        this.down('#returnShipmentItemsContainer').setVisible(false);
    },

    /**
     * @param {Ext.data.Store} returnShipmentItemsStore
     */
    showReturnShipmentItemList: function (returnShipmentItemsStore) {
        this.down('#returnShipmentItemsInfo').setVisible(false);
        this.down('#returnShipmentItemList').setVisible(true);
        this.down('#returnShipmentItemList').reconfigure(returnShipmentItemsStore);
    },

    showReturnShipmentItemsInfo: function () {
        this.down('#returnShipmentItemList').setVisible(false);
        this.down('#returnShipmentItemsInfo').setVisible(true);
    },

    enableCancelButton: function () {
        this.down('#cancelReturnShipmentsButton').setDisabled(false);
    },

    disableCancelButton: function () {
        this.down('#cancelReturnShipmentsButton').setDisabled(true);
    },

    enableFinalizeButton: function () {
        this.down('#finalizeReturnShipmentsButton').setDisabled(false);
    },

    disableFinalizeButton: function () {
        this.down('#finalizeReturnShipmentsButton').setDisabled(true);
    },

    enableAddReturnShipmentButton: function () {
        this.down('#addReturnShipmentButton').setDisabled(false);
    },

    disableAddReturnShipmentButton: function () {
        this.down('#addReturnShipmentButton').setDisabled(true);
    },

});
