// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderReturnShipment.view.detail.Window', {

    override: 'Shopware.apps.Order.view.detail.Window',

    /**
     * By overriding the default 'createTabPanel' method, a 'return shipments' tab
     * is added to the order details tab bar.
     *
     * @returns {object[]}.
     */
    createTabPanel: function () {
        var tabPanel = this.callParent(arguments);

        var positionsTabIndex = tabPanel.items.length;
        for (var i = 0; i < tabPanel.items.length; i += 1) {
            if (Ext.getClassName(tabPanel.items.get(i)) === 'Shopware.apps.Order.view.detail.Position') {
                positionsTabIndex = i;
                break;
            }
        }

        // Add a new returns tab to the panel
        var controller = this.subApp.getController(
            'Shopware.apps.ViisonPickwareERPOrderReturnShipment.controller.Tab'
        );
        tabPanel.insert(positionsTabIndex + 1, controller.createReturnShipmentsTab(this.record, this.subApp));

        return tabPanel;
    },

});
