// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderStatusBasedPositionUpdate.view.detail.Overview', {

    override: 'Shopware.apps.Order.view.detail.Overview',

    /**
     * Adds a new change listener to the status field, which saves the value that is
     * first assigned to the field.
     */
    createEditElements: function () {
        var elements = this.callParent(arguments);
        Ext.each(elements, function (element) {
            if (element.name === 'status') {
                // Add a new change listener
                var listeners = element.listeners || {};
                listeners.change = function (field, newValue, oldValue) {
                    if (oldValue === undefined) {
                        // First time the value has changed, hence save the new value in an extra field
                        field.viisonOldValue = newValue;
                    }
                };
                element.listeners = listeners;

                return false;
            }

            return undefined;
        });

        return elements;
    },

});
