// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderStatusBasedPositionUpdate.view.mail.Attachment', {

    override: 'Shopware.apps.Order.view.mail.Attachment',

    /**
     * @returns {Ext.data.Store}
     */
    createStore: function () {
        var attachmentStore = this.callParent(arguments);
        var orderRecord = this.order || this.record;

        if (!orderRecord || !orderRecord.store) {
            return attachmentStore;
        }

        // Refresh the attachments in the list of the mail window, so every document created by a status change is
        // shown in the list
        var extraParamOrderIdBackup;
        var hasExtraParams = Boolean(orderRecord.store.getProxy().extraParams);
        if (hasExtraParams) {
            extraParamOrderIdBackup = orderRecord.store.getProxy().extraParams.orderID;
        }
        var tempOrderStore = Ext.create('Shopware.apps.Order.store.Order');
        tempOrderStore.getProxy().extraParams = tempOrderStore.getProxy().extraParams || {};
        tempOrderStore.getProxy().extraParams.orderID = orderRecord.get('id');

        tempOrderStore.load({
            callback: function (records) {
                var record = records[0];
                var documents = record.getReceipt().getRange();

                // attachmentStore.removeAll or attachmentStore.loadRecords(..., {addRecords: false}) cannot be used
                // here because it would lead to a JavaScript error. We do not know the actual reason for the error.
                // Only the new documents are added to the store instead.
                documents.forEach(function (document) {
                    if (attachmentStore.getById(document.get('id')) === null) {
                        attachmentStore.add(document);
                    }
                });
            },
        });

        // Restore proxy parameters
        if (hasExtraParams) {
            orderRecord.store.getProxy().extraParams.orderID = extraParamOrderIdBackup;
        } else {
            delete orderRecord.store.getProxy().extraParams.orderID;
        }

        return attachmentStore;
    },
});
