// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOrderStockColumn.view.detail.Position', {

    override: 'Shopware.apps.Order.view.detail.Position',

    /*
     * @Override
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Change header and tooltip of the 'inStock' column
        Ext.each(columns, function (column) {
            if (column.dataIndex === 'inStock') {
                column.header = ViisonCommonApp.getSnippet(
                    'column/in_stock/header',
                    'backend/viison_pickware_erp_order_stock_column/main'
                );
                column.tooltip = ViisonCommonApp.getSnippet(
                    'column/in_stock/tooltip',
                    'backend/viison_pickware_erp_order_stock_column/main'
                );
            }
        });

        return columns;
    },

});
