// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPOverviewAmountNetColumn.view.main.Grid', {

    override: 'Shopware.apps.Overview.view.main.Grid',

    /*
     * @Override
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Insert net turnover column
        columns.splice(2, 0, {
            xtype: 'numbercolumn',
            dataIndex: 'amountNet',
            header: ViisonCommonApp.getSnippet(
                'column/amount_net/header',
                'backend/viison_pickware_erp_overview_amount_net_column/main'
            ),
            align: 'right',
            flex: 1,
            summaryType: 'sum',
            summaryRenderer: this.summaryRenderer,
            renderer: this.trendRenderer,
        });

        return columns;
    },

});
