// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.controller.Main', {

    override: 'Shopware.apps.PluginManager.controller.Main',

    /**
     * @Override
     */
    init: function () {
        // Listen on the custom global event for enabling the Pickware modules mode
        Shopware.app.Application.on({
            'enable-viison-pickware-modules-mode': this.enableViisonPickwareModulesMode,
            scope: this,
        });

        this.callParent(arguments);
    },

    /**
     * Changes width and title of the listing window and hides its navigation.
     */
    enableViisonPickwareModulesMode: function () {
        this.getListingWindow().setWidth(1102);
        this.getListingWindow().setTitle(
            ViisonCommonApp.getSnippet(
                'window/title',
                'backend/viison_pickware_erp_plugin_manager_pickware_modules/main'
            )
        );
        this.getNavigation().hide();
    },

    /**
     * @Override
     */
    afterPluginManagerLoaded: function () {
        // Check for the Pickware modules action
        if (this.subApplication.action === 'ViisonPickwareERPPluginManagerPickwareModules') {
            Shopware.app.Application.fireEvent('display-viison-pickware-modules');

            return;
        }

        this.callParent(arguments);
    },

});
