// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.controller.Navigation', {

    override: 'Shopware.apps.PluginManager.controller.Navigation',

    /**
     * @Override
     */
    init: function () {
        // Listen on the custom gloabl event for displaying the Pickware modules page
        Shopware.app.Application.on({
            'display-viison-pickware-modules': this.displayViisonPickwareModules,
            scope: this,
        });

        this.callParent(arguments);
    },

    /**
     * Tries to find the Pickware modules page in the listing window and, if found,
     * fires the custom global event to enable it and switches to its view.
     */
    displayViisonPickwareModules: function () {
        var listWindow = this.getListingWindow();

        // Try to find the Pickware modules page/card
        var pickwareModulesCardIndex = -1;
        Ext.each(listWindow.cards, function (card, index) {
            if (card === listWindow.viisonPickwareModulesPage) {
                pickwareModulesCardIndex = index;

                return false;
            }

            return undefined;
        });
        if (pickwareModulesCardIndex === -1) {
            return;
        }

        // Enable the card and swith to its view
        Shopware.app.Application.fireEvent('enable-viison-pickware-modules-mode');
        this.switchView(pickwareModulesCardIndex);
    },

});
