// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.view.list.CorePlugin', {

    extend: 'Shopware.apps.PluginManager.view.components.StorePlugin',
    alias: 'widget.viison_pickware_erp_plugin_manager_pickware_modules-core_plugin',
    cls: 'store-plugin viison_pickware_erp_plugin_manager_pickware_modules-core_plugin',

    /**
     * @override
     */
    loadRecord: function (plugin) {
        var items = this.callParent(arguments);

        switch (plugin.get('technicalName')) {
            case 'ViisonPickwareMobile':
                items.push({
                    xtype: 'container',
                    cls: 'is--additional-info is--pickware-mobile',
                    html: ViisonCommonApp.getSnippet(
                        'description/pickware_mobile/text',
                        'backend/viison_pickware_erp_plugin_manager_pickware_modules/main'
                    ),
                });
                break;
            case 'ViisonPickwarePOS':
                items.push({
                    xtype: 'container',
                    cls: 'is--additional-info is--pickware-pos',
                    html: ViisonCommonApp.getSnippet(
                        'description/pickware_pos/text',
                        'backend/viison_pickware_erp_plugin_manager_pickware_modules/main'
                    ),
                });
                break;
            default:
        }

        return items;
    },

});
