// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.view.list.CorePluginsListing', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_plugin_manager_pickware_modules-core_plugins-listing',
    cls: 'plugin-manager-listing plugin-manager-listing viison_pickware_erp_plugin_manager_pickware_modules-core_plugins-listing',

    /**
     * @override
     */
    initComponent: function () {
        this.listingContainer = Ext.create('Ext.container.Container', {
            cls: 'listing-container',
        });
        this.items = [this.listingContainer];

        this.store.on('load', function (store, records) {
            this.addItems(records);
        }, this);

        this.callParent(arguments);
    },

    /**
     * Adds the passed core plugins Pickware WMS and Pickware POS to the component's plugin listing.
     *
     * @param {Shopware.apps.PluginManager.model.Plugin[]} records
     */
    addItems: function (records) {
        var corePlugins = {};

        Ext.each(records, function (record) {
            corePlugins[record.get('technicalName')] = Ext.create(
                'Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.view.list.CorePlugin',
                {
                    record: record,
                }
            );
        }, this);

        this.listingContainer.add(corePlugins.ViisonPickwareMobile);
        this.listingContainer.add(corePlugins.ViisonPickwarePOS);
    },

});
