// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.view.list.ViisonPickwareModulesPage', {

    extend: 'Shopware.apps.PluginManager.view.list.PremiumPluginsPage',
    alias: 'widget.viison_pickware_erp_plugin_manager_pickware_modules-viison_pickware_modules_page',
    cls: 'viison_pickware_erp_plugin_manager_pickware_modules-viison_pickware_modules_page',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_plugin_manager_pickware_modules/main',

    /**
     * @override
     */
    initComponent: function () {
        // The parent initComponent function registers a 'plugin-reloaded' listener which will also be executed in this
        // custom Pickware modules page. The function does not make sense in our context and throws an error. To bypass
        // this unintended listener registration (and since the parent initComponent does nothing else), we just call
        // the parent's parent initComponent.
        Ext.getClass(this).superclass.superclass.initComponent.apply(this, arguments);
    },

    /**
     * @override
     */
    createStoreListing: function () {
        this.content = this.createContent();

        return this.content;
    },

    /**
     * @override
     */
    createContent: function () {
        // Create hidden headline and listing for other plugins
        var categoryKeyOther = 'other';
        var categoryKeyOtherHeadline = this.createPickwareCategoryStoreListingHeadline(
            this.getViisonSnippet('listings/other/title')
        );
        categoryKeyOtherHeadline.hide();
        var categoryKeyOtherListing = this.createPickwareCategoryStoreListing(categoryKeyOther);
        categoryKeyOtherListing.hide();
        categoryKeyOtherListing.store.on('load', function (store, records) {
            // Show the 'other' listing if its store has at least one result
            var method = (records.length > 0) ? 'show' : 'hide';
            categoryKeyOtherHeadline[method]();
            categoryKeyOtherListing[method]();
        }, this);

        return Ext.create('Ext.container.Container', {
            items: [
                this.createPickwareCategoryCorePluginsStoreListing(),
                this.createPickwareCategoryStoreListingHeadline(
                    this.getViisonSnippet('listings/shipping_providers/title')
                ),
                this.createPickwareCategoryStoreListing('shippingProviders'),
                this.createPickwareCategoryStoreListingHeadline(
                    this.getViisonSnippet('listings/payment_providers/title')
                ),
                this.createPickwareCategoryStoreListing('paymentProviders'),
                this.createPickwareCategoryStoreListingHeadline(
                    this.getViisonSnippet('listings/processes/title')
                ),
                this.createPickwareCategoryStoreListing('processes'),
                categoryKeyOtherHeadline,
                categoryKeyOtherListing,
            ],
        });
    },

    /**
     * @param String title
     * @return Ext.container.Container
     */
    createPickwareCategoryStoreListingHeadline: function (title) {
        return Ext.create('Ext.container.Container', {
            html: title,
            cls: 'headline',
        });
    },

    /**
     * Creates both a new store and a listing component for the Pickware sub category with the given name.
     * Finally, the listing is returned.
     *
     * @param {String} pickwareCategory
     * @return {PluginManager.components.Listing}
     */
    createPickwareCategoryStoreListing: function (pickwareCategory) {
        // Create store with a filter on category 70 (Shopware ERP) as well as the given pickwareCategory filter
        var store = Ext.create('Shopware.apps.PluginManager.store.StorePlugin', {
            pageSize: 1000,
            filters: [
                { property: 'categoryId', value: 70 },
                { property: 'pickwareCategory', value: pickwareCategory },
            ],
            autoLoad: true,
        });

        // Create the listing component
        var createListItem = this.createListItem;

        return Ext.create('PluginManager.components.Listing', {
            store: store,
            name: ('pickware-listing-' + pickwareCategory),
            scrollContainer: this,
            addItems: function (records) {
                // Sort the records by name
                records.sort(function (lhs, rhs) {
                    return lhs.get('label').localeCompare(rhs.get('label'));
                });

                // Add one listing item per record
                var plugins = [];
                Ext.each(records, function (record) {
                    plugins.push(createListItem(record));
                });
                this.listingContainer.add(plugins);
            },
        });
    },

    /**
     * Creates a new store and a listing component for the Pickware core plugin Pickware WMS and Pickware POS.
     * Finally, the listing is returned.
     *
     * @return {Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.view.list.CorePluginsListing}
     */
    createPickwareCategoryCorePluginsStoreListing: function () {
        // Create store with a filter on category 70 (Shopware ERP) as well as the given pickwareCategory filter
        var store = Ext.create('Shopware.apps.PluginManager.store.StorePlugin', {
            pageSize: 1000,
            filters: [
                { property: 'categoryId', value: 70 },
                { property: 'pickwareCategory', value: 'corePlugins' },
            ],
            autoLoad: true,
        });

        return Ext.create(
            'Shopware.apps.ViisonPickwareERPPluginManagerPickwareModules.view.list.CorePluginsListing',
            {
                store: store,
            }
        );
    },

});
