// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A singleton that holds the plugin's purchase price configuration and allows easy creation
 * of the correct 'purchase price' ('gross'/'net') labels.
 */
Ext.define('Shopware.apps.ViisonPickwareERPPurchasePriceHelper.Helper', {

    singleton: true,
    alternateClassName: 'ViisonPickwarePurchasePriceHelper',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_purchase_price_helper/main',
    viisonConfigNamespace: 'ViisonPickwareERPPurchasePriceHelper',

    constructor: function () {
        this.callParent(arguments);

        this.purchasePriceMode = this.getViisonConfig('purchasePriceMode');
    },

    /**
     * @return boolean
     */
    purchasePriceIsNet: function () {
        return this.purchasePriceMode === 'net';
    },

    /**
     * Creates a label of the form 'purchase price (mode)', where 'mode' is either 'net'
     * or 'gross', depending on the 'purchasePriceMode'. If the optional parameter 'baseLabel'
     * is given, the it is used instead of 'purchase price', resulting in the format 'baseLabel (mode)'.
     *
     * @param string|null baseLabel
     * @return string
     */
    purchasePriceLabel: function (baseLabel) {
        var label = baseLabel || this.getViisonSnippet('purchase_price');
        var modeLabel = this.purchasePriceIsNet() ? this.getViisonSnippet('net') : this.getViisonSnippet('gross');

        return label + ' (' + modeLabel + ')';
    },

});
