// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.controller.ReturnShipmentItemsPicker', {

    extend: 'Ext.app.Controller',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/return_shipment_items_picker',

    refs: [
        {
            ref: 'returnShipmentItemList',
            selector: 'viison_pickware_erp_return_shipment-return_shipment_items_picker-return_shipment_item_list',
        },
    ],

    /**
     * @type {Shopware.apps.ViisonPickwareERPReturnShipment.view.ReturnShipmentItemsPicker.Window}
     */
    mainWindow: null,

    /**
     * Callback, which will be called when the user clicks the select button.
     *
     * @type {function}
     */
    actionCallback: Ext.emptyFn,

    /**
     * @override
     */
    init: function () {
        this.callParent(arguments);

        this.control({
            'viison_pickware_erp_return_shipment-return_shipment_items_picker-window': {
                closeWindow: this.onCloseWindow,
                selectReturnShipmentItems: this.onSelectReturnShipmentItems,
            },
            'viison_pickware_erp_return_shipment-return_shipment_items_picker-return_shipment_item_list': {
                openArticle: this.onOpenArticle,
                selectionchange: this.onSelectionChange,
            },
        });
    },

    /**
     * @override
     *
     * Scope refs to main window
     *
     * @param {string} selector
     * @returns {Ext.Component}
     */
    getActiveReference: function (selector) {
        return Ext.ComponentQuery.query(selector, this.mainWindow)[0];
    },

    /**
     * @param {number} orderId
     * @param {Ext.data.Store} storeOfExcludedReturnShipmentItems
     * @param {function} actionCallback
     */
    createWindow: function (orderId, storeOfExcludedReturnShipmentItems, actionCallback) {
        this.getStore('ReturnShipmentItemsPicker.ReturnShipmentItem').setReturnShipmentItemsFilter(
            storeOfExcludedReturnShipmentItems
        );

        this.actionCallback = actionCallback;
        this.mainWindow = this.getView('ReturnShipmentItemsPicker.Window').create({
            orderId: orderId,
        });
        this.mainWindow.show();
    },

    onCloseWindow: function () {
        this.mainWindow.close();
    },

    onSelectReturnShipmentItems: function () {
        var selectedReturnShipmentItems = this.getReturnShipmentItemList().getSelectionModel().getSelection();
        if (selectedReturnShipmentItems.length === 0) {
            return;
        }

        // Set returned quantity of all selected return shipment items to max value (= shipped quantity)
        selectedReturnShipmentItems.forEach(function (returnShipmentItem) {
            returnShipmentItem.set('returnedQuantity', returnShipmentItem.get('shippedQuantity'));
        });

        this.mainWindow.close();
        this.actionCallback(selectedReturnShipmentItems);
    },

    /**
     * @param {Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.ReturnShipmentItem} returnShipmentItem
     */
    onOpenArticle: function (returnShipmentItem) {
        Shopware.app.Application.addSubApplication({
            name: 'Shopware.apps.Article',
            action: 'detail',
            params: {
                articleId: returnShipmentItem.get('articleId'),
            },
        });
    },

    /**
     * Updates the status of the select button based on the given selection of return shipment items.
     *
     * @param {Ext.selection.rowModel} selectionModel
     * @param {Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.ReturnShipmentItem[]} selection
     */
    onSelectionChange: function (selectionModel, selection) {
        if (selection.length > 0) {
            this.mainWindow.enableSelectButton();
        } else {
            this.mainWindow.disableSelectButton();
        }
    },

});
