// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.ReturnShipment', {

    extend: 'Ext.data.Model',

    fields: [
        { name: 'id', type: 'int', useNull: true, default: null },
        { name: 'number', type: 'string', default: '' },
        { name: 'statusId', type: 'int' },
        { name: 'documentId', type: 'string' },
        { name: 'targetWarehouseId', type: 'int' },
    ],

    associations: [
        {
            type: 'hasOne',
            model: 'Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.Order',
            associationKey: 'order',
            name: 'getOrder',
            getterName: 'getOrder',
        },
        {
            type: 'hasOne',
            model: 'Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.Customer',
            associationKey: 'customer',
            name: 'getCustomer',
            getterName: 'getCustomer',
        },
        {
            type: 'hasMany',
            model: 'Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.ReturnShipmentItem',
            name: 'getItems',
            associationKey: 'items',
        },
        {
            type: 'hasMany',
            model: 'Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.Attachment',
            name: 'getAttachments',
            associationKey: 'attachments',
        },
        {
            type: 'hasMany',
            model: 'Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.InternalComment',
            name: 'getInternalComments',
            associationKey: 'internalComments',
        },
    ],

    proxy: {
        type: 'ajax',
        api: {
            read: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPReturnShipment/getReturnShipment'),
            update: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPReturnShipment/updateReturnShipment'),
        },
        reader: {
            type: 'json',
            root: 'data',
        },
        writer: Ext.create(
            'Shopware.apps.ViisonCommonData.proxy.writer.WriterWithSupportForHasOneAssociations',
            {
                root: 'data',
            }
        ),
    },

    /**
     * Returns true if a return shipment already exists on the server side, whereby a return shipment is
     * meant to be existing if it already has a return shipment number assigned to it.
     *
     * @returns {boolean}
     */
    isCreated: function () {
        return this.get('number') !== '';
    },

    /**
     * @returns {boolean}
     */
    hasCorrectionOfInvoice: function () {
        return Boolean(this.get('documentId'));
    },

    /**
     * @returns {boolean}
     */
    isTypeNew: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_NEW_ID;
    },

    /**
     * @returns {boolean}
     */
    isTypeReceived: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_RECEIVED_ID;
    },

    /**
     * @returns {boolean}
     */
    isTypeCancelled: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_CANCELLED_ID;
    },

    /**
     * @returns {boolean}
     */
    isTypeFinalized: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_COMPLETED_ID;
    },

    /**
     * @returns {boolean}
     */
    canBeCanceled: function () {
        return this.isTypeReceived();
    },

    /**
     * @returns {boolean}
     */
    canBeFinalized: function () {
        return this.isTypeReceived() || this.isTypeCancelled();
    },

});
