// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.model.overview.ReturnShipment', {

    extend: 'Ext.data.Model',

    fields: [
        { name: 'id', type: 'int' },
        { name: 'statusId', type: 'int' },
        { name: 'created', type: 'date' },
        { name: 'number', type: 'string' },
        { name: 'orderId', type: 'int' },
        { name: 'orderNumber', type: 'string' },
        { name: 'orderStatusName', type: 'string' },
        { name: 'orderShopName', type: 'string' },
        { name: 'paymentStatusName', type: 'string' },
        { name: 'paymentMethodName', type: 'string' },
        { name: 'numberOfReturnedItems', type: 'int' },
        { name: 'userId', type: 'int' },
        { name: 'userName', type: 'string' },
        { name: 'customerId', type: 'int' },
        { name: 'customerName', type: 'string' },
        { name: 'customerEmail', type: 'string' },
        { name: 'customerCompanyName', type: 'string' },
        { name: 'customerGroupKey', type: 'string' },
        { name: 'customerNumber', type: 'string' },
        { name: 'shippingMethodName', type: 'string' },
        { name: 'documentId', type: 'string', useNull: true },
        { name: 'amount', type: 'float' },
    ],

    /**
     * @returns {boolean}
     */
    isTypeCancelled: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_CANCELLED_ID;
    },

    /**
     * @returns {boolean}
     */
    isTypeFinalized: function () {
        return this.get('statusId') === ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_COMPLETED_ID;
    },

});
