// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.model.ReturnShipmentStatus', {

    extend: 'Ext.data.Model',
    alternateClassName: 'ViisonPickwareERPReturnShipmentReturnShipmentStatus',

    fields: [
        { name: 'id', type: 'int' },
        { name: 'name', type: 'string' },
        {
            name: 'displayName',
            type: 'string',
            convert: function (val, record) {
                return record.self.localizedDisplayName(record.get('id'));
            },
        },
    ],

    statics: {
        STATUS_NEW_ID: 4,
        STATUS_RECEIVED_ID: 1,
        STATUS_CANCELLED_ID: 3,
        STATUS_COMPLETED_ID: 2,

        /**
         * @param {number} statusId
         * @returns {boolean}
         */
        returnShipmentCanBeCancelled: function (statusId) {
            return statusId === this.STATUS_RECEIVED_ID;
        },

        /**
         * @param {number} statusId
         * @returns {boolean}
         */
        returnShipmentCanBeFinalized: function (statusId) {
            return statusId === this.STATUS_RECEIVED_ID || statusId === this.STATUS_CANCELLED_ID;
        },

        /**
         * @param {number} value
         * @returns {string}
         */
        localizedDisplayName: function (value) {
            switch (value) {
                case this.STATUS_NEW_ID:
                    return ViisonCommonApp.getSnippet(
                        'return_shipment_status/new',
                        'backend/viison_pickware_erp_return_shipment/main'
                    );
                case this.STATUS_RECEIVED_ID:
                    return ViisonCommonApp.getSnippet(
                        'return_shipment_status/received',
                        'backend/viison_pickware_erp_return_shipment/main'
                    );
                case this.STATUS_CANCELLED_ID:
                    return ViisonCommonApp.getSnippet(
                        'return_shipment_status/cancelled',
                        'backend/viison_pickware_erp_return_shipment/main'
                    );
                case this.STATUS_COMPLETED_ID:
                    return ViisonCommonApp.getSnippet(
                        'return_shipment_status/completed',
                        'backend/viison_pickware_erp_return_shipment/main'
                    );
                default:
                    return ViisonCommonApp.getSnippet(
                        'return_shipment_status/unknown',
                        'backend/viison_pickware_erp_return_shipment/main'
                    );
            }
        },
    },

});
