// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.store.overview.ReturnShipment', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPReturnShipment.model.overview.ReturnShipment',

    remoteFilter: true,
    remoteSort: true,
    sorters: [{
        property: 'created',
        direction: 'DESC',
    }],
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPReturnShipment/getReturnShipments'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

    /**
     * Updates the stores status id filter based on a given set of status ids an reloads the store.
     *
     * @param {number[]} selectedStatusIds
     */
    setStatusFilter: function (selectedStatusIds) {
        if (!this.filterValueHasChanged('selectedStatusIds', selectedStatusIds)) {
            return;
        }

        if (selectedStatusIds.length > 0) {
            this.filters.add('selectedStatusIds', Ext.create('Ext.util.Filter', {
                property: 'statusId',
                value: selectedStatusIds,
            }));
        } else {
            this.filters.removeAtKey('selectedStatusIds');
        }

        this.loadPage(1);
    },

    /**
     * Evaluates if the value of a filter given by its key has indeed changed.
     *
     * @param {string} filterKey
     * @param {string} filterValue
     * @returns {boolean}
     */
    filterValueHasChanged: function (filterKey, filterValue) {
        var currentFilter = this.filters.findBy(function (filter, key) {
            return key === filterKey;
        });

        if (!currentFilter && filterValue.length === 0) {
            return false;
        }

        if (currentFilter
            && currentFilter.value.length === filterValue.length
            && Ext.Array.difference(currentFilter.value, filterValue).length === 0
        ) {
            return false;
        }

        return true;
    },

});
