// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.store.ReturnShipmentItemsPicker.ReturnShipmentItem', {

    extend: 'Ext.data.Store',
    model: 'Shopware.apps.ViisonPickwareERPReturnShipment.model.detail.ReturnShipmentItem',

    remoteFilter: false,
    remoteSort: false,
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPReturnShipment/getReturnShipmentItemCandidates'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

    /**
     * Filters the store by excluding all return shipments, which are part of a given store of
     * return shipments.
     *
     * @param {Ext.data.Store} storeOfExcludedReturnShipmentItems
     */
    setReturnShipmentItemsFilter: function (storeOfExcludedReturnShipmentItems) {
        var excludedOrderDetailIds = [];
        storeOfExcludedReturnShipmentItems.each(function (returnShipmentItemRecord) {
            excludedOrderDetailIds.push(returnShipmentItemRecord.get('orderDetailId'));
        });

        this.clearFilter(true);
        this.filter([{
            filterFn: function (record) {
                return Ext.Array.indexOf(excludedOrderDetailIds, record.get('orderDetailId')) === -1;
            },
        }]);
    },

});
