// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.Content', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-content',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    border: false,
    bodyStyle: {
        border: 'none !important',
    },

    layout: {
        type: 'hbox',
        align: 'stretch',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);

        this.subApp.getController('Detail').on('returnShipmentRecordSaved', function () {
            this.reconfigureView();
        }, this);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            this.subApp.getView('detail.GeneralInfo').create({
                itemId: 'generalInfoPanel',
                width: 320,
            }),
            this.subApp.getView('detail.TabPanel').create({
                itemId: 'tabPanel',
                flex: 1,
            }),
        ];
    },

    /**
     * @returns {object[]}
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware',
                cls: 'is--viison-common--button-panel',
                items: [
                    '->',
                    {
                        text: this.getViisonSnippet('window/button/close_window/text'),
                        tooltip: this.getViisonSnippet('window/button/close_window/tooltip'),
                        cls: 'secondary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('closeWindow', this);
                        },
                    }, {
                        text: this.getViisonSnippet('window/button/cancel_return_shipment/text'),
                        tooltip: this.getViisonSnippet('window/button/cancel_return_shipment/tooltip'),
                        itemId: 'cancelReturnShipmentButton',
                        cls: 'primary',
                        scope: this,
                        disabled: !this.subApp.getController('Detail').getReturnShipmentRecord().canBeCanceled(),
                        handler: function () {
                            this.fireEvent('cancelReturnShipment', this);
                        },
                    }, {
                        text: this.getViisonSnippet('window/button/finalize_return_shipment/text'),
                        tooltip: this.getViisonSnippet('window/button/finalize_return_shipment/tooltip'),
                        itemId: 'finalizeReturnShipmentButton',
                        cls: 'primary',
                        scope: this,
                        disabled: !this.subApp.getController('Detail').getReturnShipmentRecord().canBeFinalized(),
                        handler: function () {
                            this.fireEvent('finalizeReturnShipment', this);
                        },
                    }, {
                        text: this.getViisonSnippet('window/button/save/text'),
                        cls: 'primary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('saveReturnShipment', this);
                        },
                    },
                ],
            },
        ];
    },

    reconfigureView: function () {
        var returnShipmentRecord = this.subApp.getController('Detail').getReturnShipmentRecord();

        this.down('#cancelReturnShipmentButton').setDisabled(!returnShipmentRecord.canBeCanceled());
        this.down('#finalizeReturnShipmentButton').setDisabled(!returnShipmentRecord.canBeFinalized());
    },

});
