// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-general_info',
    cls: 'viison_pickware_erp_return_shipment-detail-general_info viison-common--sidebar has--no-border is--left-sidebar',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    autoScroll: true,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            this.subApp.getView('detail.GeneralInfo.Header').create(),
            this.subApp.getView('detail.GeneralInfo.CorrectionOfInvoice').create(),
            this.subApp.getView('detail.GeneralInfo.Order').create(),
            this.subApp.getView('detail.GeneralInfo.Customer').create(),
        ];
    },

});
