// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Box', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-general_info-box',
    cls: 'viison_pickware_erp_return_shipment-detail-general_info-box',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    title: '',
    hideButton: false,
    buttonEventName: null,
    buttonText: '',
    buttonReplacementText: '',

    /**
     * @override
     */
    initComponent: function () {
        this.items = Ext.Array.merge(
            this.createPreHeaderItems(),
            this.createHeaderItems(),
            this.createItems()
        );

        this.callParent(arguments);
    },

    /**
     * @returns {array}
     */
    createPreHeaderItems: function () {
        return [];
    },

    /**
     * @returns {object[]}
     */
    createHeaderItems: function () {
        return [
            {
                xtype: 'container',
                cls: 'is--box-header',
                layout: {
                    type: 'hbox',
                    align: 'bottom',
                },
                height: 35,
                items: [
                    {
                        xtype: 'box',
                        cls: 'is--box-title',
                        itemId: 'boxTitle',
                        flex: 1,
                        autoEl: {
                            tag: 'div',
                            html: this.title,
                        },
                    }, {
                        xtype: 'button',
                        itemId: 'boxButton',
                        cls: 'primary small',
                        text: this.buttonText,
                        hidden: this.hideButton,
                        scope: this,
                        handler: function () {
                            this.fireEvent(this.buttonEventName, this);
                        },
                    }, {
                        xtype: 'container',
                        itemId: 'boxButtonRepacement',
                        cls: 'is--button-replacement-text',
                        html: this.buttonReplacementText,
                        hidden: !this.hideButton,
                    },
                ],
            },
        ];
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [];
    },

    /**
     * @param {string} newTitle
     */
    updateTitle: function (newTitle) {
        this.down('#boxTitle').el.dom.innerHTML = newTitle;
    },

});
