// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.CorrectionOfInvoice', {

    extend: 'Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Box',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-general_info-correction_of_invoice',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('general_info/correction_of_invoice/title');
        this.buttonText = this.getViisonSnippet('general_info/correction_of_invoice/button/text');
        this.hideButton = !this.subApp.getController('Detail').getReturnShipmentRecord().hasCorrectionOfInvoice();
        this.buttonEventName = 'openDocument';
        this.buttonReplacementText = this.getViisonSnippet(
            'general_info/correction_of_invoice/button_replacement_text'
        );
        this.cls = this.cls + ' is--correction-of-invoice';

        this.callParent(arguments);

        this.subApp.getController('Detail').on('returnShipmentRecordSaved', function () {
            this.reconfigureView();
        }, this);
    },

    reconfigureView: function () {
        var returnShipmentRecord = this.subApp.getController('Detail').getReturnShipmentRecord();

        if (returnShipmentRecord.hasCorrectionOfInvoice()) {
            this.down('#boxButtonRepacement').setVisible(false);
            this.down('#boxButton').setVisible(true);
        } else {
            this.down('#boxButtonRepacement').setVisible(true);
            this.down('#boxButton').setVisible(false);
        }

        this.doLayout();
    },

});
