// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Customer', {

    extend: 'Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Box',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-general_info-customer',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('general_info/customer/title');
        this.buttonText = this.getViisonSnippet('general_info/customer/button/text');
        this.buttonEventName = 'openCustomer';

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        var customerRecord = this.subApp.getController('Detail').getReturnShipmentRecord().getCustomer();

        return [
            {
                xtype: 'container',
                layout: {
                    type: 'vbox',
                    align: 'stretch',
                },
                items: [
                    {
                        xtype: 'container',
                        html: this.getTemplate().apply({
                            customerCompany: customerRecord.get('company'),
                            customerSalutation: customerRecord.get('salutation'),
                            customerName: customerRecord.get('name'),
                            customerNumber: customerRecord.get('number'),
                            customerGroupName: customerRecord.get('groupName'),
                            customerEmail: customerRecord.get('email'),
                            customerPhone: customerRecord.get('phone'),
                        }),
                    },
                ],
            },
        ];
    },

    /**
     * @returns {Ext.XTemplate}
     */
    getTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="is--content-row has--single-column is--customer-name-container">',
                    '<p>',
                        '<span class="is--customer-salutation">{customerSalutation}</span>',
                        '<span class="is--customer-name">{customerName}</span>',
                        '<tpl if="customerCompany">',
                            '<span class="is--customer-company">{customerCompany}</span>',
                        '</tpl>',
                    '</p>',
                '</div>',
                '<div class="is--content-row has--two-columns">',
                    '<div>',
                        '<p class="is--label">',
                            '<span>',
                                this.getViisonSnippet('general_info/customer/customer_number/label'),
                            '</span>',
                        '</p>',
                        '<p>',
                            '<span>{customerNumber}</span>',
                        '</p>',
                    '</div>',
                    '<div>',
                        '<p class="is--label">',
                            '<span>',
                                this.getViisonSnippet('general_info/customer/customer_group_name/label'),
                            '</span>',
                        '</p>',
                        '<p>',
                            '<span>{customerGroupName}</span>',
                        '</p>',
                    '</div>',
                '</div>',
                '<div class="is--content-row has--single-column">',
                    '<p class="is--label">',
                        '<span>',
                            this.getViisonSnippet('general_info/customer/email/label'),
                        '</span>',
                    '</p>',
                    '<p>',
                        '<span>{customerEmail}</span>',
                    '</p>',
                '</div>',
                '<div class="is--content-row has--single-column">',
                    '<p class="is--label">',
                        '<span>',
                            this.getViisonSnippet('general_info/customer/phone/label'),
                        '</span>',
                    '</p>',
                    '<p>',
                        '<span>{customerPhone}</span>',
                    '</p>',
                '</div>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
