// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Header', {

    extend: 'Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Box',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-general_info-header',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.renderTitle();
        this.cls = this.cls + ' is--emphasized';
        this.hideButton = true;

        this.callParent(arguments);

        this.subApp.getController('Detail').on('returnShipmentRecordSaved', function () {
            this.reconfigureView();
        }, this);
    },

    /**
     * @override
     */
    createPreHeaderItems: function () {
        return [
            {
                xtype: 'container',
                cls: 'is--box-status-badge',
                items: [
                    {
                        xtype: 'box',
                        cls: 'is--badge is--type-' + this.getStatusCode(),
                        itemId: 'statusInfo',
                        autoEl: {
                            tag: 'span',
                            html: this.getStatusLabel(),
                        },
                    },
                ],
            },
        ];
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'container',
                cls: 'is--target-warehouse-container',
                layout: {
                    type: 'vbox',
                    align: 'stretch',
                },
                items: [
                    {
                        xtype: 'label',
                        cls: 'is--viison-common--label',
                        text: this.getViisonSnippet('general_info/target_warehouse/label'),
                        margin: '0 10 6 0',
                    }, {
                        xtype: 'viison_pickware_erp_warehouse_management-warehouse_combo_box',
                        name: 'warehouseSelection',
                        itemId: 'warehouseSelection',
                        store: this.subApp.getController('Detail').getWarehouseStore(),
                        autoLoadStore: false,
                        value: this.subApp.getController('Detail').getReturnShipmentRecord().get('targetWarehouseId'),
                        helpText: this.getViisonSnippet('general_info/target_warehouse/helptext'),
                        hideLabel: true,
                        disabled: !this.subApp.getController('Detail').getReturnShipmentRecord().isTypeNew(),
                        listeners: {
                            select: function (combobox, selection) {
                                this.fireEvent('targetWarehouseChange', selection);
                            },
                            scope: this,
                        },
                    },
                ],
            },
        ];
    },

    renderTitle: function () {
        return Ext.String.format(
            this.getViisonSnippet('general_info/header/title'),
            '<strong>' + this.subApp.getController('Detail').getReturnShipmentRecord().get('number') + '</strong>'
        );
    },

    /**
     * @returns {string}
     */
    getStatusCode: function () {
        switch (this.subApp.getController('Detail').getReturnShipmentRecord().get('statusId')) {
            case ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_NEW_ID:
                return 'new';
            case ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_RECEIVED_ID:
                return 'received';
            case ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_CANCELLED_ID:
                return 'cancelled';
            case ViisonPickwareERPReturnShipmentReturnShipmentStatus.STATUS_COMPLETED_ID:
                return 'completed';
            default:
                return '';
        }
    },

    /**
     * @returns {string}
     */
    getStatusLabel: function () {
        return ViisonPickwareERPReturnShipmentReturnShipmentStatus.localizedDisplayName(
            this.subApp.getController('Detail').getReturnShipmentRecord().get('statusId')
        );
    },

    reconfigureView: function () {
        var returnShipmentRecord = this.subApp.getController('Detail').getReturnShipmentRecord();

        this.down('#warehouseSelection').setDisabled(!returnShipmentRecord.isTypeNew());
        this.down('#warehouseSelection').setValue(returnShipmentRecord.get('targetWarehouseId'));

        this.down('#statusInfo').el.dom.innerHTML = this.getStatusLabel();
        this.down('#statusInfo').el.replaceCls(
            [
                'is--type-new',
                'is--type-received',
                'is--type-completed',
            ],
            'is--type-' + this.getStatusCode()
        );

        this.updateTitle(this.renderTitle());
    },

});
