// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Order', {

    extend: 'Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.GeneralInfo.Box',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-general_info-order',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('general_info/order/title');
        this.buttonText = this.getViisonSnippet('general_info/order/button/text');
        this.buttonEventName = 'openOrder';

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        var orderRecord = this.subApp.getController('Detail').getReturnShipmentRecord().getOrder();

        return [
            {
                xtype: 'container',
                layout: {
                    type: 'vbox',
                    align: 'stretch',
                },
                items: [
                    {
                        xtype: 'container',
                        html: this.getTemplate().apply({
                            number: orderRecord.get('number'),
                            paymentMethodName: orderRecord.get('paymentMethodName'),
                        }),
                    },
                ],
            },
        ];
    },

    /**
     * @returns {Ext.XTemplate}
     */
    getTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="is--content-row has--two-columns">',
                    '<div>',
                        '<p class="is--label">',
                            '<span>',
                                this.getViisonSnippet('general_info/order/number/label'),
                            '</span>',
                        '</p>',
                        '<p>',
                            '<span>{number}</span>',
                        '</p>',
                    '</div>',
                    '<div>',
                        '<p class="is--label">',
                            '<span>',
                                this.getViisonSnippet('general_info/order/payment_method/label'),
                            '</span>',
                        '</p>',
                        '<p>',
                            '<span>{paymentMethodName}</span>',
                        '</p>',
                    '</div>',
                '</div>',
            '</tpl>'
        );
        /* eslint-enable indent */
    },

});
