// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.tab.Attachments', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-tab-attachments',
    cls: 'viison_pickware_erp_return_shipment-detail-tab-attachments',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    layout: 'fit',
    border: false,

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('tab/attachments/title');
        this.items = this.createItems();

        this.callParent(arguments);

        this.subApp.getController('Detail').on('returnShipmentRecordSaved', function () {
            this.reconfigureView();
        }, this);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        var returnShipmentRecord = this.subApp.getController('Detail').getReturnShipmentRecord();

        return [
            this.subApp.getView('detail.tab.attachments.InfoPanel').create({
                itemId: 'infoPanel',
                hidden: returnShipmentRecord.isCreated(),
            }),
            this.subApp.getView('detail.tab.attachments.AttachmentList').create({
                itemId: 'attachmentListPanel',
                hidden: !returnShipmentRecord.isCreated(),
            }),
        ];
    },

    reconfigureView: function () {
        var returnShipmentRecord = this.subApp.getController('Detail').getReturnShipmentRecord();

        this.down('#infoPanel').setVisible(!returnShipmentRecord.isCreated());
        this.down('#attachmentListPanel').setVisible(returnShipmentRecord.isCreated());
    },

});
