// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.tab.attachments.AttachmentList', {

    extend: 'Ext.panel.Panel',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-tab-attachments-attachment_list',
    cls: 'viison_pickware_erp_return_shipment-detail-tab-attachments-attachment_list',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    uploadUrl: ViisonCommonApp.assembleBackendUrl('mediaManager/upload', {
        albumID: ViisonCommonApp.getConfig(
            'viisonPickwareERPReturnShipmentAlbumId',
            'ViisonPickwareERPReturnShipment'
        ),
    }),

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    style: {
        borderTop: 'none !important',
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderBottom: 'none !important',
    },
    bodyStyle: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderBottom: 'none !important',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);

        this.subApp.getController('Detail').on('returnShipmentRecordSaved', function () {
            this.reconfigureView();
        }, this);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'html5fileupload',
                requestURL: this.uploadUrl,
                hideOnLegacy: true,
                showInput: false,
                checkType: false,
                checkAmount: false,
                enablePreviewImage: false,
                dropZoneText: this.getViisonSnippet('tab/attachments/drop_zone_text'),
                height: 100,
                listeners: {
                    fileUploaded: function (xhr) {
                        this.fireEvent('attachmentUploaded', xhr);
                    },
                    uploadReady: function () {
                        this.fireEvent('attachmentBeforeUpload');
                    },
                    scope: this,
                },
            },
            {
                xtype: 'dataview',
                itemId: 'attachmentList',
                flex: 1,
                bodyStyle: {
                    border: 'none !important',
                },
                cls: 'is--view-container',
                tpl: this.getMediaViewTemplate(),
                store: this.subApp.getController('Detail').getReturnShipmentRecord().getAttachments(),
                emptyText: [
                    '<span class="is--empty-text">',
                    this.getViisonSnippet('tab/attachments/empty_text'),
                    '</span>',
                ].join(''),
                deferEmptyText: false,
                itemSelector: '.thumb-wrap',
                multiSelect: true,
                autoScroll: true,
                listeners: {
                    selectionchange: function (model, selection) {
                        this.fireEvent('attachmentsSelectionChange', selection);
                    },
                    scope: this,
                },
            },
        ];
    },

    /**
     * @returns {Ext.toolbar.Toolbar[]}
     */
    createDockedItems: function () {
        return [
            Ext.create('Ext.toolbar.Toolbar', {
                dock: 'top',
                ui: 'shopware-ui',
                cls: 'is--viison-common--toolbar',
                items: [
                    {
                        xtype: 'filefield',
                        buttonOnly: true,
                        buttonText: this.getViisonSnippet('tab/attachments/button/add_attachment/text'),
                        buttonConfig: {
                            iconCls: 'icon-add',
                            margin: '0 5 0 0',
                        },
                    },
                    {
                        xtype: 'button',
                        itemId: 'downloadButton',
                        text: this.getViisonSnippet('tab/attachments/button/download_attachment/text'),
                        iconCls: 'icon-download',
                        margin: '0 5 0 0',
                        disabled: true,
                        scope: this,
                        handler: function () {
                            this.fireEvent(
                                'downloadAttachment',
                                this.down('#attachmentList').getSelectionModel().getSelection()
                            );
                        },
                    },
                    {
                        xtype: 'button',
                        text: this.getViisonSnippet('tab/attachments/button/delete_attachments/text'),
                        itemId: 'deleteButton',
                        iconCls: 'icon-remove',
                        margin: '0 5 0 0',
                        disabled: true,
                        scope: this,
                        handler: function () {
                            this.fireEvent(
                                'deleteAttachments',
                                this.down('#attachmentList').getSelectionModel().getSelection()
                            );
                        },
                    },
                ],
            }),
        ];
    },

    /**
     * @returns {Ext.XTemplate}
     */
    getMediaViewTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="thumb-wrap" id="{fileName}">',
                    '<tpl if="type == &quot;IMAGE&quot;">',
                        // Type is image, hence show the image
                        '<div class="thumb">',
                            '<div class="inner-thumb">',
                                '<img src="{thumbnail}" title="{fileName}" />',
                            '</div>',
                        '</div>',
                    '<tpl else>',
                        // No image, hence just show an icon
                        '<div class="thumb icon">',
                            '<div class="icon-{type:this.convertToLowerCase}">&nbsp;</div>',
                        '</div>',
                    '</tpl>',
                    '<span class="x-editable">{fileName:this.shortenFileName}.{extension}</span>',
                '</div>',
            '</tpl>',
            '<div class="x-clear"></div>',
            {
                convertToLowerCase: function (type) {
                    return type.toLowerCase();
                },
                shortenFileName: function (fileName) {
                    return Ext.util.Format.ellipsis(fileName, 24);
                },
            }
        );
        /* eslint-enable indent */
    },

    enableDownloadButton: function () {
        this.down('#downloadButton').setDisabled(false);
    },

    disableDownloadButton: function () {
        this.down('#downloadButton').setDisabled(true);
    },

    enableDeleteButton: function () {
        this.down('#deleteButton').setDisabled(false);
    },

    disableDeleteButton: function () {
        this.down('#deleteButton').setDisabled(true);
    },

    reconfigureView: function () {
        this.down('#attachmentList').bindStore(
            this.subApp.getController('Detail').getReturnShipmentRecord().getAttachments()
        );
    },

});
