// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.tab.attachments.InfoPanel', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-tab-attachments-info_panel',
    cls: 'viison_pickware_erp_return_shipment-detail-tab-attachments-info_panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    layout: 'fit',
    border: false,

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'box',
                cls: 'is--info-text',
                autoEl: {
                    tag: 'div',
                    html: Ext.String.format(
                        '<strong>[0]</strong>[1]',
                        this.getViisonSnippet('tab/attachments/info_text/headline'),
                        this.getViisonSnippet('tab/attachments/info_text/body')
                    ),
                },
            },
        ];
    },

});
