// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.tab.InternalComments', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-tab-internal_comments',
    cls: 'viison_pickware_erp_return_shipment-detail-tab-internal_comments',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    style: {
        border: 'none !important',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('tab/internal_comments/title');
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            this.subApp.getView('detail.tab.InternalComments.AddCommentForm').create({
                height: 178,
            }),
            this.subApp.getView('detail.tab.InternalComments.InternalCommentList').create({
                flex: 1,
            }),
        ];
    },

});
