// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.tab.InternalComments.AddCommentForm', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-tab-internal_comments-add_comment_form',
    cls: 'viison_pickware_erp_return_shipment-detail-tab-internal_comments-add_comment_form',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    bodyStyle: {
        border: 'none !important',
        backgroundColor: 'transparent !important',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'textarea',
                itemId: 'comment',
                name: 'comment',
                emptyText: this.getViisonSnippet('tab/internal_comments/textarea/placeholder_text'),
                flex: 1,
                value: '',
                listeners: {
                    scope: this,
                    change: function (field, newValue) {
                        if (newValue) {
                            this.down('#button').setDisabled(false);
                        } else {
                            this.down('#button').setDisabled(true);
                        }
                    },
                },
            },
            {
                xtype: 'container',
                items: [
                    {
                        xtype: 'button',
                        itemId: 'button',
                        cls: 'primary',
                        margin: '10 0 0 0',
                        style: {
                            float: 'right',
                        },
                        disabled: true,
                        text: this.getViisonSnippet('tab/internal_comments/button/add_comment/text'),
                        handler: function () {
                            this.fireEvent('addInternalComment', this.down('#comment').getValue());
                            this.down('#comment').setValue('');
                        },
                        scope: this,
                    },
                ],
            },
        ];
    },

});
