// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.tab.InternalComments.InternalCommentList', {

    extend: 'Ext.container.Container',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-tab-internal_comments-internal_comment_list',
    cls: 'viison_pickware_erp_return_shipment-detail-tab-internal_comments-internal_comment_list',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    layout: 'fit',

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);

        this.subApp.getController('Detail').on('returnShipmentRecordSaved', function () {
            this.reconfigureView();
        }, this);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            {
                xtype: 'dataview',
                itemId: 'internalCommentList',
                cls: 'is--view-container',
                bodyStyle: {
                    border: 'none !important',
                },
                tpl: this.getItemTemplate(),
                store: this.subApp.getController('Detail').getReturnShipmentRecord().getInternalComments(),
                emptyText: [
                    '<span class="is--empty-text">',
                    this.getViisonSnippet('tab/internal_comments/list/empty_text'),
                    '</span>',
                ].join(''),
                deferEmptyText: false,
                itemSelector: '.is--comment-container',
                autoScroll: true,
                listeners: {
                    selectionchange: function (model, selection) {
                        this.fireEvent('attachmentsSelectionChange', selection);
                    },
                    itemclick: function (dataview, record, item, index, event) {
                        if (event.getTarget('div.is--delete-button')) {
                            this.fireEvent('deleteInternalComment', record);
                        }
                    },
                    scope: this,
                },
            },
        ];
    },

    /**
     * @returns {Ext.XTemplate}
     */
    getItemTemplate: function () {
        /* eslint-disable indent */
        return new Ext.XTemplate(
            '<tpl for=".">',
                '<div class="is--comment-container">',
                    '<div class="is--comment-inner-container">',
                        '<div class="is--comment-info">',
                            '<span class="is--creation-time">{created:this.renderDateTime}</span>',
                            '<span class="is--username">{userName}</span>',
                        '</div>',
                        '<p class="is--comment">',
                            '<span>{comment}</span>',
                        '</p>',
                    '</div>',
                    '<div class="is--delete-button icon-remove"></div>',
                '</div>',
            '</tpl>',
            {
                renderDateTime: function (value) {
                    return Ext.String.format(
                        this.getViisonSnippet('tab/internal_comments/list/date/format'),
                        Ext.util.Format.date(value, 'd.m.Y'),
                        Ext.util.Format.date(value, 'H:i')
                    );
                }.bind(this),
            }
        );
        /* eslint-enable indent */
    },

    reconfigureView: function () {
        this.down('#internalCommentList').bindStore(
            this.subApp.getController('Detail').getReturnShipmentRecord().getInternalComments()
        );
    },

});
