// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.TabPanel', {

    extend: 'Ext.tab.Panel',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-tab_panel',
    cls: 'viison_pickware_erp_return_shipment-detail-tab_panel viison-common--tab-panel',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    style: {
        border: 'none !important',
    },

    bodyStyle: {
        border: 'none !important',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @return {object[]}
     */
    createItems: function () {
        return [
            this.subApp.getView('detail.tab.ReturnShipmentItemList').create(),
            this.subApp.getView('detail.tab.Attachments').create(),
            this.subApp.getView('detail.tab.InternalComments').create(),
        ];
    },

});
