// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.detail.Window', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_return_shipment-detail-window',
    cls: 'viison-common--window has--no-border',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/detail',

    layout: 'fit',
    width: 1100,
    height: '90%',

    /**
     * @override
     */
    initComponent: function () {
        this.title = Ext.String.format(
            this.getViisonSnippet('window/title'),
            ''
        );
        this.items = [];

        this.callParent(arguments);

        this.subApp.getController('Detail').on('returnShipmentRecordSaved', function () {
            this.reconfigureView();
        }, this);
    },

    /**
     * @param {string} message
     */
    showLoadMask: function (message) {
        this.loadMask = this.loadMask || new Ext.LoadMask(this);

        this.loadMask.msg = message || this.getViisonSnippet('window/loading_mask/text');
        this.loadMask.show();
    },

    hideLoadMask: function () {
        this.loadMask.hide();
    },

    reconfigureView: function () {
        this.setTitle(Ext.String.format(
            this.getViisonSnippet('window/title'),
            this.subApp.getController('Detail').getReturnShipmentRecord().get('number')
        ));
    },

});
