// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.OrderPicker.OrderList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_return_shipment-order_picker-order_list',
    cls: 'viison_pickware_erp_return_shipment-order_picker-order_list viison-common--grid has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/order_picker',

    stateful: true,
    stateId: 'viison_pickware_erp_return_shipment-order_picker-order_list',

    style: {
        borderLeft: 'none !important',
        borderRight: 'none !important',
        borderBottom: 'none !important',
    },
    bodyStyle: {
        borderTop: 'none !important',
        borderLeft: 'none !important',
        borderRight: 'none !important',
    },

    viewConfig: {
        enableTextSelection: true,
        trackOver: true,
        markDirty: false,
    },

    selModel: {
        selType: 'rowmodel',
        mode: 'SINGLE',
    },

    /**
     * @override
     */
    initComponent: function () {
        this.emptyText = this.getViisonSnippet('order_list/empty_text');
        this.store = this.subApp.getStore('OrderPicker.Order');
        this.columns = this.createColumns();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);

        setTimeout(function () {
            // Load store in next tick, since otherwise the emptyText will
            // not be displayed properly
            this.store.load();
        }.bind(this), 100);
    },

    /**
     * @returns {object[]}
     */
    createColumns: function () {
        return [
            {
                hideable: false,
                menuDisabled: true,
                tdCls: 'is--checkbox',
                width: 28,
            }, {
                xtype: 'datecolumn',
                header: this.getViisonSnippet('order_list/column/order_time'),
                dataIndex: 'orderTime',
                sortable: true,
                width: 100,
                format: 'd.m.Y H:i',
            }, {
                header: this.getViisonSnippet('order_list/column/number'),
                dataIndex: 'number',
                sortable: true,
                width: 80,
            }, {
                header: this.getViisonSnippet('order_list/column/order_shop_name'),
                dataIndex: 'orderShopName',
                sortable: true,
                width: 100,
                hidden: true,
            }, {
                header: this.getViisonSnippet('order_list/column/customer_name'),
                dataIndex: 'customerName',
                sortable: true,
                flex: 1,
                renderer: function (value, metaData, record) {
                    var customerCompanyName = record.get('customerCompanyName');
                    if (!customerCompanyName) {
                        return value;
                    }

                    return value + ' (' + customerCompanyName + ')';
                },
            }, {
                header: this.getViisonSnippet('order_list/column/customer_number'),
                dataIndex: 'customerNumber',
                sortable: true,
                width: 80,
                hidden: true,
            }, {
                header: this.getViisonSnippet('order_list/column/customer_group_key'),
                dataIndex: 'customerGroupKey',
                sortable: true,
                width: 80,
                hidden: true,
            }, {
                header: this.getViisonSnippet('order_list/column/shipping_method_name'),
                dataIndex: 'shippingMethodName',
                sortable: true,
                width: 100,
                hidden: true,
            }, {
                header: this.getViisonSnippet('order_list/column/payment_method_name'),
                dataIndex: 'paymentMethodName',
                sortable: true,
                width: 100,
            }, {
                header: this.getViisonSnippet('order_list/column/order_status'),
                dataIndex: 'orderStatusName',
                sortable: true,
                width: 100,
                renderer: function (value) {
                    return ViisonStatusTranslator.translateOrderStatus(value);
                },
            }, {
                header: this.getViisonSnippet('order_list/column/payment_status'),
                dataIndex: 'paymentStatusName',
                sortable: true,
                width: 100,
                renderer: function (value) {
                    return ViisonStatusTranslator.translatePaymentStatus(value);
                },
            }, {
                xtype: 'actioncolumn',
                width: 60,
                align: 'center',
                items: [
                    {
                        iconCls: 'sprite-user',
                        tooltip: this.getViisonSnippet('order_list/button/open_customer/tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex) {
                            this.fireEvent('openCustomer', grid.getStore().getAt(rowIndex));
                        },
                    }, {
                        iconCls: 'sprite-sticky-notes-pin',
                        tooltip: this.getViisonSnippet('order_list/button/open_order/tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex) {
                            this.fireEvent('openOrder', grid.getStore().getAt(rowIndex));
                        },
                    },
                ],
            },
        ];
    },

    /**
     * @returns {object[]}
     */
    createDockedItems: function () {
        return [
            Ext.create('Ext.toolbar.Toolbar', {
                dock: 'top',
                ui: 'shopware-ui',
                cls: 'is--viison-common--toolbar',
                items: [
                    '->',
                    {
                        xtype: 'textfield',
                        name: 'searchfield',
                        cls: 'searchfield',
                        width: 170,
                        enableKeyEvents: true,
                        emptyText: this.getViisonSnippet('order_list/toolbar/search/placeholder'),
                        listeners: {
                            buffer: 500,
                            change: function (field) {
                                this.fireEvent('searchStrChange', field.value);
                            },
                            scope: this,
                        },
                    },
                ],
            }),
            {
                xtype: 'viison_common_pagination_toolbar-toolbar',
                store: this.store,
            },
        ];
    },

});
