// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.OrderPicker.Window', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_return_shipment-order_picker-window',
    cls: 'viison-common--window has--no-border',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/order_picker',

    modal: true,
    layout: 'fit',

    width: 800,
    height: '60%',

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.items = this.createItems();
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    createItems: function () {
        return [
            this.subApp.getView('OrderPicker.OrderList').create(),
        ];
    },

    /**
     * @returns {object[]}
     */
    createDockedItems: function () {
        return [
            {
                xtype: 'toolbar',
                dock: 'bottom',
                ui: 'shopware',
                cls: 'is--viison-common--button-panel is--primary',
                items: [
                    '->',
                    {
                        text: this.getViisonSnippet('window/button/cancel/text'),
                        cls: 'secondary',
                        scope: this,
                        handler: function () {
                            this.fireEvent('closeWindow', this);
                        },
                    }, {
                        text: this.getViisonSnippet('window/button/select_order/text'),
                        itemId: 'buttonSelect',
                        cls: 'primary',
                        scope: this,
                        disabled: true,
                        handler: function () {
                            this.fireEvent('selectOrder', this);
                        },
                    },
                ],
            },
        ];
    },

    enableSelectButton: function () {
        this.down('#buttonSelect').setDisabled(false);
    },

    disableSelectButton: function () {
        this.down('#buttonSelect').setDisabled(true);
    },

});
