// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.overview.Window', {

    extend: 'Enlight.app.Window',
    alias: 'widget.viison_pickware_erp_return_shipment-overview-window',
    cls: 'viison-common--window has--no-border',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/overview',

    layout: 'fit',
    width: 1200,
    height: '80%',

    /**
     * @override
     */
    initComponent: function () {
        this.title = this.getViisonSnippet('window/title');
        this.items = this.createItems();

        this.callParent(arguments);
    },

    /**
     * @returns {object[]}
     */
    createItems: function () {
        return [
            this.subApp.getView('overview.ReturnShipmentList').create(),
        ];
    },

    /**
     * @param {string} message
     */
    showLoadMask: function (message) {
        this.loadMask = this.loadMask || new Ext.LoadMask(this);

        this.loadMask.msg = message || this.getViisonSnippet('window/loading_mask/text');
        this.loadMask.show();
    },

    hideLoadMask: function () {
        this.loadMask.hide();
    },

});
