// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPReturnShipment.view.ReturnShipmentItemsPicker.ReturnShipmentItemList', {

    extend: 'Ext.grid.Panel',
    alias: 'widget.viison_pickware_erp_return_shipment-return_shipment_items_picker-return_shipment_item_list',
    cls: 'viison_pickware_erp_return_shipment-return_shipment_items_picker-return_shipment_item_list viison-common--grid has--vertical-lines',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_return_shipment/return_shipment_items_picker',

    stateful: true,
    stateId: 'viison_pickware_erp_return_shipment-return_shipment_items_picker-return_shipment_item_list',

    style: {
        border: 'none !important',
    },
    bodyStyle: {
        border: 'none !important',
    },

    viewConfig: {
        enableTextSelection: true,
        trackOver: true,
        markDirty: false,
        deferEmptyText: false,
    },

    selModel: {
        selType: 'checkboxmodel',
        mode: 'SIMPLE',
        checkOnly: false,
    },

    orderId: null,

    /**
     * @override
     */
    initComponent: function () {
        this.emptyText = this.getViisonSnippet('return_shipment_item_list/empty_text');
        this.store = this.subApp.getStore('ReturnShipmentItemsPicker.ReturnShipmentItem');
        this.columns = this.createColumns();

        this.callParent(arguments);

        this.store.getProxy().extraParams = {
            orderId: this.orderId,
        };

        this.store.load();
    },

    /**
     * @returns {object[]}
     */
    createColumns: function () {
        return [
            {
                header: this.getViisonSnippet('return_shipment_item_list/column/article_number'),
                dataIndex: 'articleNumber',
                sortable: true,
                width: 120,
            }, {
                header: this.getViisonSnippet('return_shipment_item_list/column/article_name'),
                dataIndex: 'articleName',
                sortable: true,
                flex: 1,
            }, {
                header: this.getViisonSnippet('return_shipment_item_list/column/shipped_quantity'),
                dataIndex: 'shippedQuantity',
                sortable: true,
                align: 'right',
                width: 80,
            }, {
                xtype: 'actioncolumn',
                width: 54,
                align: 'center',
                items: [
                    {
                        iconCls: 'sprite-inbox',
                        tooltip: this.getViisonSnippet('return_shipment_item_list/column/button/open_article/tooltip'),
                        scope: this,
                        handler: function (grid, rowIndex) {
                            this.fireEvent('openArticle', grid.getStore().getAt(rowIndex));
                        },
                    },
                ],
            },
        ];
    },

});
