<!DOCTYPE html>
<html lang="de">
    <head>
        <meta charset="utf-8">
        <title></title>
        <style type="text/css">

            body {
                margin: 0;
                padding: 5px 20px 20px;
                font-family: Arial, Verdana, sans-serif;
                font-size: 12px;
                line-height: 1.5;
                color: #475c6a;
            }

            p {
                display: block;
                margin-bottom: 15px;
            }

            strong {
                font-weight: bold;
            }

            ul,
            ol {
                padding-left: 20px;
            }

            li {
                margin-bottom: 15px;
                list-style: disc;
            }

            h2 {
                margin-bottom: 10px;
                font-size: 16px;
                opacity: 0.6;
            }

            p ~ h2 {
                margin-top: 25px;
            }

            .is--alert {
                margin-left: -2px;
                padding: 15px;
                border: 1px solid #cdd6dc;
                background-color: #F3F5F7;
            }

        </style>
    </head>
    <body>
        <p>
            Mit der Einführung von <strong>Pickware</strong> als vollintegrierte Warenwirtschaft in Shopware stehen Ihnen eine
            Vielzahl weiterer Funktionen zur Verfügung! Eine wichtige Grundlage für diese Funktionen ist die
            Unterscheidung in verschiedene Lagerbestände. Diese Trennung ermöglicht Ihnen zu jedem Zeitpunkt eine
            verbesserte Übersicht über Ihren Warenbestand.
        </p>
        <p>
            Dabei unterscheidet Pickware zwischen dem physisch vorhandenen Bestand im Lager und dem im Shopware Frontend
            verfügbaren Bestand, der an den Kunden im Shop verkauft werden kann. Dabei ist zu beachten, dass der
            <strong>physische Lagerbestand</strong> keine negativen Werte annehmen kann. Demgegenüber kann der
            <strong>verfügbare Lagerbestand</strong> in Shopware abhängig von der Einstellung <strong>Abverkauf</strong>
            negative Werte aufweisen.
        </p>
        <p>
            Der verfügbare Lagerbestand entspricht dem Bestand, der Ihnen bereits aus der Nutzung von Shopware ohne
            Pickware bekannt ist. Basierend auf diesem Lagerbestand ist es nun notwendig Ihren neuen <strong>physischen
            Lagerbestand</strong> korrekt zu initialisieren. Um diese Bestandsinitialisierung durchzuführen, ist es
            wichtig die Werte in den folgenden, im unteren Dialogfeld aufgeführten, Spalten zu überprüfen und gegebenenfalls
            Anpassungen durchzuführen. Hier folgt zunächst eine Erläuterung einiger <strong>Begriffe</strong>. Im Weiteren
            finden Sie <strong>Hinweise</strong>, die im Rahmen der Initialisierung Ihrer Bestände zu beachten sind.
        </p>
        <ul>
            <li>
                <strong>Verfügbarer Lagerbestand</strong>: Entspricht dem bisherigen Shopware Lagerbestand und kann
                direkt angepasst werden.
            </li>
            <li>
                <strong>Physischer Lagerbestand</strong>: Bestimmt sich einmalig aus dem Wert des verfügbaren Lagerbestands
                und den Artikelmengen, die in Kundenbestellungen enthalten sind, die nicht den Bestellstatus <i>Komplett
                ausgeliefert</i> oder <i>Storniert/Abgelehnt</i> aufweisen. Dieser Wert sollte dem physisch vorhandenen
                Bestand in Ihrem Lager entsprechen.
            </li>
            <li>
                <strong>Reservierter Lagerbestand</strong>: Soll der Summe aus den bestellten Mengen dieses Artikels
                entsprechen. Hierunter fallen alle Kundenbestellungen, die den Artikel beinhalten und nicht über den
                Bestellstatus <i>Komplett ausgeliefert</i> oder <i>Storniert/Abgelehnt</i> verfügen. Dieser Wert bestimmt
                sich rechnerisch aus der Differenz des physischen und verfügbaren Lagerbestands.
            </li>
            <li>
                <strong>Einkaufspreis ({if $purchasePriceMode === 'net'}netto{else}brutto{/if})</strong>: gibt den
                Einkaufspreis eines Artikels für die Bewertung des vorhandenen Warenbestandes an. Dieser Wert kann
                direkt in der Liste angepasst werden. Für alle zukünftigen Wareneingänge können mit Pickware
                unterschiedliche Einkaufspreise pro Lieferung hinterlegt werden.
            </li>
        </ul>
        <p class="is--alert">
            <strong>Besonders wichtig:</strong> Die Anzahl der bestellten und noch nicht ausgelieferten Artikel sollte
            in <i>Artikel > Bestellungen</i> überprüft werden, sodass der Wert in der Spalte <strong>reservierter
            Lagerbestand</strong> mit den tatsächlich vorhandenen offenen Bestellmengen zu diesem Artikel
            übereinstimmt!
        </p>
        <p>
            Mit einem Klick auf <strong>Übernehmen</strong> wird der Lagerbestand für die ausgewählten Artikel
            initialisiert.
        </p>
        <p>
            <strong>Empfohlene Vorgehensweise für eine korrekte Initialisierung:</strong>
        </p>
        <p>
            Um sicherzustellen, dass die Bestände korrekt initialisiert werden, sollten Sie die folgenden Schritte
            durchführen:
        </p>
        <ul>
            <li>
                <strong>Bestehende Bestellungen überprüfen:</strong> Überprüfen Sie, dass sich Ihre alten, bereits
                versandten Bestellungen im Status <i>Komplett ausgeliefert</i> befinden. Um dies sicherzustellen,
                können Sie in der Bestellübersicht nach allen weiteren Bestellstatus filtern. Bearbeiten Sie anschließend
                jene Bestellungen, deren Status nicht <strong>Komplett ausgeliefert</strong> oder
                <strong>Storniert/Abgelehnt</strong> ist, z.B. mithilfe der Stapelverarbeitung. Dies ist notwendig, da
                alle Bestellungen, die einen anderen Bestellstatus aufweisen, als <i>offene, nicht versandte</i>
                Bestellungen berücksichtigt werden. Die in diesen Bestellungen enthaltenen Artikelmengen dienen als
                Grundlage zur einmaligen Berechnung Ihres physischen Lagerbestands. Bitte beachten Sie hierbei, dass im
                Rahmen der Änderung des Bestellstatus auf <i>Komplett ausgeliefert</i> keine Bestandseinträge geschrieben
                werden, damit die von Ihnen gepflegten Lagerbestände nicht nachträglich verändert werden. Um dies zu
                verhindern, achten Sie bitte darauf, dass in der Stapelverarbeitung die Option <i>Positionen als
                'versandt' markieren</i> <strong>deaktiviert</strong> ist bzw. dass Sie in dem Dialogfeld, das beim
                Bearbeiten des Status einer einzelnen Bestellung angezeigt wird, <strong>"Nein"</strong> auswählen.
            </li>
            <li>
                <strong>Einkaufspreise setzen:</strong> Stellen Sie sicher, dass die Einkaufspreise aller Artikel und deren
                Varianten korrekt hinterlegt sind, damit der bewertete Warenbestand auf Basis dessen bestimmt werden kann.
                Bearbeiten Sie die Einkaufspreise der Artikel entsprechend, indem Sie diese entweder in den Stammdaten der
                Artikeldetails oder über die Mehrfachänderung (Feld "Detail.purchasePrice") anpassen. Eine weitere
                Möglichkeit Ihre Einkaufspreise korrekt einzupflegen bietet der CSV-Import über das Shopware Import/Export
                Modul unter <i>Inhalte > Import/Export</i>.
            </li>
            <li>
                <strong>Bestandsinitialisierung seitenweise durchführen:</strong> Um Fehler in Ihren Beständen vor der
                Initialisierung festzustellen, sollten Sie nach Möglichkeit die Initialisierung seitenweise durchführen.
                Das heißt, markieren Sie die unten aufgeführten Artikel und klicken Sie auf <strong>Übernehmen</strong>,
                um deren Bestände zu initialisieren. Es ist nicht empfohlen, den Button <strong>Alle initalisieren</strong>
                zu verwenden, außer die seitenweise Initialisierung führt aufgrund der Anzahl der Artikel bzw. Varianten
                im Shop zu einem unverhältnismäßig hohen Aufwand.
            </li>
        </ul>
        <p>
            Falls Sie ebenfalls <strong>Pickware Mobile</strong> verwenden, sollten Sie nach der Initialisierung Ihrer
            Bestände eine <strong>Inventur</strong> durchführen.
        </p>
    </body>
</html>
