<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title></title>
        <style type="text/css">

            body {
                margin: 0;
                padding: 5px 20px 20px;
                font-family: Arial, Verdana, sans-serif;
                font-size: 12px;
                line-height: 1.5;
                color: #475c6a;
            }

            p {
                display: block;
                margin-bottom: 15px;
            }

            strong {
                font-weight: bold;
            }

            ul,
            ol {
                padding-left: 20px;
            }

            li {
                margin-bottom: 15px;
                list-style: disc;
            }

            h2 {
                margin-bottom: 10px;
                font-size: 16px;
                opacity: 0.6;
            }

            p ~ h2 {
                margin-top: 25px;
            }

            .is--alert {
                margin-left: -2px;
                padding: 15px;
                border: 1px solid #cdd6dc;
                background-color: #F3F5F7;
            }

        </style>
    </head>
    <body>
        <p>
            With the introduction of <strong>Pickware</strong> as fully integrated ERP in Shopware, a multitude of
            further functions are available to you! An important basis for these functions is the differentiation
            into different stock types. This differentiation allows you an improved overview of your stock at
            any time.
        </p>
        <p>
            Pickware distinguishes between the physical stock in your warehouse and the stock available in the
            Shopware frontend, which can be sold to the customer in your shop. Please note that the <strong>physical
            stock</strong> cannot have negative values. In contrast, the <strong>available stock</strong> in
            Shopware allows negative values depending on the setting <strong>last stock</strong>.
        </p>
        <p>
            The available stock corresponds to the stock that you already know from the use of Shopware without
            Pickware. Based on this stock it is now necessary to initialize your new <strong>physical stock</strong>
            correctly. To perform this stock initialization, it is important to check the values in the following
            columns listed in the lower dialog box and make any necessary adjustments. Here follows an explanation
            of some <strong>terms</strong>. You will also find <strong>notes</strong>, which should be kept in mind
            when initializing your stocks.
        </p>
        <ul>
            <li>
                <strong>Available stock:</strong> Corresponds to the previous shopware stock and can be adjusted
                directly.
            </li>
            <li>
                <strong>Physical warehouse stock:</strong> Is determined initially based on the value of the
                available stock and the item quantities contained in customer orders that do not have the order
                status <i>Completely delivered</i> or <i>Cancelled/rejected</i>. This value should correspond to
                the physical stock in your warehouse.
            </li>
            <li>
                <strong>Reserved stock:</strong> Should correspond to the total of the ordered quantities of
                this item. This includes all customer orders that contain the item and do not have the order
                status <i>Completely delivered</i> or <i>Cancelled/rejected</i>. This value is calculated from
                the difference between the physical and available stock.
            </li>
            <li>
                <strong>Purchase price ({if $purchasePriceMode === 'net'}netto{else}brutto{/if})</strong>: Specifies
                the average purchase price for the valuation of the available stock. This value can be adjusted
                directly in the list. Different purchase prices per delivery can be stored for all future supplier
                orders with Pickware.
            </li>
        </ul>
        <p class="is--alert">
            <strong>Particularly important:</strong> The number of items ordered but not yet shipped should be
            checked in <i>items > orders</i> so that the value in the column <strong>reserved stock</strong> matches
            the actual open order quantities for this item!
        </p>
        <p>
            With a click on <strong>Apply</strong> the warehouse stock for the selected items is initialized.
        </p>
        <p>
            <strong>Recommended procedure for a correct initialization:</strong>
        </p>
        <p>
            To ensure that your stocks are initialized correctly, you should carry out the following steps:
        </p>
        <ul>
            <li>
                <strong>Check existing orders:</strong> Check that your old, already shipped orders have the
                status <i>Completely delivered</i>. To ensure this, you can filter for all other order statuses
                in the order overview. Then process those customer orders whose status is not <strong>Completely
                delivered</strong> or <strong>Cancelled/rejected</strong>, for example, using batch processing.
                This is necessary because all customer orders with a different order status are taken into account
                as <i>open, not shipped</i> orders. The item quantities contained in those orders serve as the basis
                for the one-time calculation of your physical stock. Please make sure that no stock entries are
                written when you change the order status to <i>Completely delivered</i> so that the stocks you
                maintained are not subsequently changed. To prevent this, please make sure that the option <i>Mark
                positions as shipped</i> in batch processing is <strong>disabled</strong> or that you select
                <strong>"no"</strong> in the dialog box that appears when editing the status of an individual order.
            </li>
            <li>
                <strong>Set Purchase Prices:</strong> Make sure that the purchase prices of all items and their
                variants are correctly stored so that the valuated stock can be determined on this basis. Edit the
                purchase prices of the articles accordingly by adjusting them either in the master data of the
                article details or by making multiple changes ("Detail.purchasePrice" field). Another possibility
                to enter your purchase prices correctly is the CSV-Import via the Shopware Import/Export module
                under <i>Contents > Import/Export</i>.
            </li>
            <li>
                <strong>Execute stock initialization page by page:</strong> To determine errors in your stocks
                before initialization, you should carry out the initialization page by page if possible. That
                is, select the items listed below and click <strong>Apply</strong> to initialize their stocks.
                It is not recommended to use the <strong>Initialize all</strong> button. An exception would
                be a disproportionately high effort by the page by page initialization due to the number of
                items and variants in your shop.
            </li>
        </ul>
        <p>
            If you also use <strong>Pickware Mobile</strong>, you should perform a <strong>stock take</strong>
            after initializing your stocks.
        </p>
    </body>
</html>
